

// Header File for IK121Con.cpp




#ifndef INC_IK121APP_H
#define INC_IK121APP_H


#ifdef __cplusplus
extern "C"
{
#endif
	WINUSERAPI BOOL WINAPI IKFind	        (ULONG*  pBuffer8);
	WINUSERAPI BOOL WINAPI IKInit	        (USHORT Axis, USHORT Mode);
	WINUSERAPI BOOL WINAPI IKVersion        (USHORT Axis, char* pVersCard, char* pVersDrv, char* pVersDll);

	WINUSERAPI BOOL WINAPI IKReset	        (USHORT Axis);
	WINUSERAPI BOOL WINAPI IKStart	        (USHORT Axis);
	WINUSERAPI BOOL WINAPI IKStop	        (USHORT Axis);
	WINUSERAPI BOOL WINAPI IKLatch          (USHORT Axis, USHORT Latch);

	WINUSERAPI BOOL WINAPI IKResetREF       (USHORT Axis);
	WINUSERAPI BOOL WINAPI IKStartREF       (USHORT Axis);
	WINUSERAPI BOOL WINAPI IKStopREF        (USHORT Axis);
	WINUSERAPI BOOL WINAPI IKLatchREF       (USHORT Axis, USHORT Latch);

	WINUSERAPI BOOL WINAPI IKLatched        (USHORT Axis, USHORT Latch, BOOL* pStatus);
	WINUSERAPI BOOL WINAPI IKWaitLatch      (USHORT Axis, USHORT Latch);

	WINUSERAPI BOOL WINAPI IKStrtCodRef     (USHORT Axis, USHORT Latch, ULONG RefDist);
	WINUSERAPI BOOL WINAPI IKCodRef	        (USHORT Axis, BOOL* pStatus, double* pData);
	WINUSERAPI BOOL WINAPI IKWaitCodRef     (USHORT Axis, double* pData);
	WINUSERAPI BOOL WINAPI IKStopCodRef     (USHORT Axis);

	WINUSERAPI BOOL WINAPI IKClear	        (USHORT Axis);
	WINUSERAPI BOOL WINAPI IKStatus         (USHORT Axis, ULONG* pStatus);

	WINUSERAPI BOOL WINAPI IKRead32         (USHORT Axis, USHORT Latch, LONG*   pData);
	WINUSERAPI BOOL WINAPI IKRead48         (USHORT Axis, USHORT Latch, double* pData);

	WINUSERAPI BOOL WINAPI IKReadPhase      (USHORT Axis, BYTE* pData);
	WINUSERAPI BOOL WINAPI IKWritePhase     (USHORT Axis, BYTE   Data);
	WINUSERAPI BOOL WINAPI IKLoadPhase      (USHORT Axis, BYTE* pData);

	WINUSERAPI BOOL WINAPI IKReadAmp        (USHORT Axis, BYTE* pData);
	WINUSERAPI BOOL WINAPI IKWriteAmp       (USHORT Axis, BYTE   Data);
	WINUSERAPI BOOL WINAPI IKLoadAmp        (USHORT Axis, BYTE* pData);

	WINUSERAPI BOOL WINAPI IKReadOffset     (USHORT Axis, SHORT* Ofs0, SHORT* Ofs90);
	WINUSERAPI BOOL WINAPI IKWriteOffset    (USHORT Axis, SHORT  Ofs0, SHORT  Ofs90);
	WINUSERAPI BOOL WINAPI IKLoadOffset	    (USHORT Axis, SHORT* Ofs0, SHORT* Ofs90);

	WINUSERAPI BOOL WINAPI IKStore	 	    (USHORT Axis);
	WINUSERAPI BOOL WINAPI IKDefault		(USHORT Axis);

	WINUSERAPI BOOL WINAPI IKRomRead        (USHORT Card, BYTE  Adr, BYTE* Data);
	WINUSERAPI BOOL WINAPI IKRomWrite	    (USHORT Card, BYTE  Adr, BYTE  Data);


	WINUSERAPI BOOL WINAPI IKInputW	        (USHORT Axis, USHORT Adr, USHORT* pBuffer);
	WINUSERAPI BOOL WINAPI IKInputL	        (USHORT Axis, USHORT Adr, ULONG*  pBuffer);
	WINUSERAPI BOOL WINAPI IKOutput	        (USHORT Axis, USHORT Adr, USHORT  Data);

	WINUSERAPI BOOL WINAPI IKSetI2C		    (USHORT Card, BOOL SCL, BOOL SDA);
#ifdef __cplusplus
}
#endif


#endif			  


